<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Výškové řešení Rozhledová vzdálenost</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis Výškové řešení Rozhledová vzdálenost</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <xsl:for-each select="HorizontalAlignment[VerticalAlignment]">
                                    <table class="margin" width="90%">
                                        <colgroup span="5">
                                            <col width="18%"/>
                                            <col width="13%"/>
                                            <col width="25%"/>
                                            <col width="22%"/>
                                            <col width="22%"/>
                                        </colgroup>
                                        <thead>
                                            <tr>
                                                <th align="right" colspan="2" lang="en"><br/>Směrové řešení:</th>
                                                <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Popis:</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Styl:</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@style"/></td>
                                            </tr>
                                            <tr>
                                                <th/>
                                                <th/>
                                                <th align="right" class="underline" lang="en">Station</th>
                                                <th align="right" class="underline" lang="en">Elevation</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Vertical Alignment Data -->
                                            <xsl:for-each select="VerticalAlignment">
                                                <tr>
                                                    <th align="right" colspan="2" lang="en"><br/>Výškové řešení:</th>
                                                    <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Popis:</th>
                                                    <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Styl:</th>
                                                    <td align="left" colspan="3"><xsl:value-of select="@style"/></td>
                                                </tr>
                                                <xsl:apply-templates/>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Vertical Alignment Linear Data -->
    <xsl:template match="VerticalLine">
      <tr>
        <td align="left" colspan="4" lang="en">
          <br/>Prvek: Přímá
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2">
          <xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
        </td>
      </tr>
      <xsl:if test="StationEquation">
        <tr>
          <td align="right" colspan="2" lang="en">StanPuv</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
          </td>
        </tr>
        <tr>
          <td align="right" colspan="2" lang="en">StanNove</td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
          </td>
        </tr>
      </xsl:if>
      <tr>
        <td align="right" colspan="2">
          <xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2" lang="en">Sklon tečny:</td>
        <td align="right">
          <xsl:value-of select="cif:gradeFormat(number(@grade))"/>
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2" lang="en">Délka tečny:</td>
        <td align="right">
          <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        </td>
      </tr>
    </xsl:template>
    <!-- Vertical Alignment Symmetrical Parabola Data -->
  <xsl:template match="VerticalSymmetricalParabola">
    <tr>
      <td align="left" colspan="4" lang="en">
        <br/>Prvek: Symmetrická parabola
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(PVI/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <tr>
        <td align="right" colspan="2" lang="en">StanPuv</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2" lang="en">StanNove</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="TurningPoint">
      <tr>
        <td align="right" colspan="2">
          <xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2" lang="en">Délka:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@verticalCurveLength))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Vstupní sklon:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Výstupní sklon:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">r = (g2 - g1) / L:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@rateOfChange))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">K = l / (g2 - g1):</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@kValue))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@midOrdinate))"/>
      </td>
    </tr>
    <xsl:if test="SightDistance">
      <xsl:if test="SightDistance/@eyeHeight">
        <tr>
          <td align="right" colspan="2" lang="en">Výška očí:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@eyeHeight))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@stoppingObjectHeight">
        <tr>
          <td align="right" colspan="2" lang="en">Zastavení Výška objektu:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@stoppingObjectHeight))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@stoppingSightDistance">
        <tr>
          <td align="right" colspan="2" lang="en">Zastavení Vzdálenost rozhledu:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@stoppingSightDistance))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@headLightSightDistance">
        <tr>
          <td align="right" colspan="2" lang="en">Světlo Vzdálenost rozhledu:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@headLightSightDistance))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@sightDistance">
        <tr>
          <td align="right" colspan="2" lang="en">Vzdálenost rozhledu:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@sightDistance))"/>
          </td>
        </tr>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="VerticalUnsymmetricalParabola">
    <tr>
      <td align="left" colspan="4" lang="en">
        <br/>Prvek: Nesymetrická parabola
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(PVI/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(PVCC/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(PVCC/station/@externalStation), string(PVCC/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PVCC/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <tr>
        <td align="right" colspan="2" lang="en">StanPuv</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2" lang="en">StanNove</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="TurningPoint">
      <tr>
        <td align="right" colspan="2">
          <xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2" lang="en">Délka vjezdu:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@startVerticalCurveLength))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Délka výjezdu:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@endVerticalCurveLength))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Sklon vjezdu:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Sklon výjezdu:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">r = (g2 - g1) / L:</td>
      <td align="right">
        Vjezd: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@startRateOfChange))"/>
      </td>
      <td align="right">
        Výjezd: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@endRateOfChange))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">K = l / (g2 - g1):</td>
      <td align="right">
        Vjezd: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@startKValue))"/>
      </td>
      <td align="right">
        Výjezd: &#xa0;<xsl:value-of select="cif:distanceFormat(number(@endKValue))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@midOrdinate))"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="VerticalCircle">
    <tr>
      <td align="left" colspan="4" lang="en">
        <br/>Prvek: Oblouk
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(PVI/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalCenter/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalCenter/station/@externalStation), string(VerticalCenter/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalCenter/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <tr>
        <td align="right" colspan="2" lang="en">StanPuv</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2" lang="en">StanNove</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="TurningPoint">
      <tr>
        <td align="right" colspan="2">
          <xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2" lang="en">Poloměr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Délka:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Vjezd sklon:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Výjezd sklon:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
      </td>
    </tr>
    <xsl:if test="SightDistance">
      <xsl:if test="SightDistance/@eyeHeight">
        <tr>
          <td align="right" colspan="2" lang="en">Výška očí:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@eyeHeight))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@stoppingObjectHeight">
        <tr>
          <td align="right" colspan="2" lang="en">Zastavení Výška objektu:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@stoppingObjectHeight))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@stoppingSightDistance">
        <tr>
          <td align="right" colspan="2" lang="en">Zastavení Rozhledová vzdálenost:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@stoppingSightDistance))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@headLightSightDistance">
        <tr>
          <td align="right" colspan="2" lang="en">Světla Rozhledová vzdálenost:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@headLightSightDistance))"/>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="SightDistance/@sightDistance">
        <tr>
          <td align="right" colspan="2" lang="en">Rozhledová vzdálenost:</td>
          <td align="right">
            <xsl:value-of select="cif:distanceFormat(number(SightDistance/@sightDistance))"/>
          </td>
        </tr>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="VerticalClothoid">
    <tr>
      <td align="left" colspan="4" lang="en">
        <br/>Prvek: Klotoida
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(PVI/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="StationEquation">
      <tr>
        <td align="right" colspan="2" lang="en">StanPuv</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@backStation), string(StationEquation/@backEquation))"/>
        </td>
      </tr>
      <tr>
        <td align="right" colspan="2" lang="en">StanNove</td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(StationEquation/@aheadStation), string(StationEquation/@aheadEquation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2">
        <xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
      </td>
      <td align="right">
        <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
      </td>
    </tr>
    <xsl:if test="TurningPoint">
      <tr>
        <td align="right" colspan="2">
          <xsl:value-of select="cif:pointType(string(TurningPoint/@pointType))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:stationFormat(number(TurningPoint/station/@externalStation), string(TurningPoint/station/@externalStationName))"/>
        </td>
        <td align="right">
          <xsl:value-of select="cif:ordinateFormat(number(TurningPoint/@elevation))"/>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td align="right" colspan="2" lang="en">Vjezd Poloměr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@startRadius))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Výjezd Poloměr:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@endRadius))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Délka:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Úhel:</td>
      <td align="right">
        <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
      </td>
      <td>
        <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
        <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Dlouhá tečna:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Krátká tečna:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">X:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@xs))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Y:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@ys))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">dR:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@p))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Xs:</td>
      <td align="right">
        <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Vstupní sklon:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@startGrade))"/>
      </td>
    </tr>
    <tr>
      <td align="right" colspan="2" lang="en">Výstupní sklon:</td>
      <td align="right">
        <xsl:value-of select="cif:gradeFormat(number(@endGrade))"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Pro tento výpis musíte vybrat nejméně jeden Civl prvek výškové geometrie.
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2012 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
